# -*- coding: utf-8 -*- 
"""Subclass of MainFrame, which is generated by wxFormBuilder."""

import wx
import ui
import os
import sys
import platform
import images
from threading import *
from wx.lib.pubsub import pub
import time
import logging
import subprocess
import locale
import traceback
import webbrowser

from uiDialogAbout import uiDialogAbout

sys.path.append(os.path.join(os.path.abspath(os.path.dirname(sys.argv[0])), 'modules'))
from config import ConverterConfig
import fb2conv

reload(sys)
sys.setdefaultencoding(locale.getpreferredencoding())

EVT_RESULT_ID = wx.NewId()

SUPPORT_URL = u'http://www.the-ebook.org/forum/viewtopic.php?t=28447'

PROCESS_START = 0
PROCESS_ABORT = 1
PROCESS_DONE = 2
PROCESS_BEGIN = 3 
PROCESS_END = 4

ICON_CURRENT = 1
ICON_SUCCESS = 2
ICON_ERROR = 3

def EVT_RESULT(win, func):
    win.Connect(-1, -1, EVT_RESULT_ID, func)

class ResultEvent(wx.PyEvent):
    def __init__(self, mode, filename=None, state=None):
        wx.PyEvent.__init__(self)
        self.SetEventType(EVT_RESULT_ID)
        self.mode = mode
        self.filename = filename
        self.state = state

class Worker(Thread):
    def __init__(self, notify_window, files, profile, outputdir, outputformat, log):
        Thread.__init__(self)
        self.notify_window = notify_window
        self.stop_process = False
        self.files = files
        self.outputdir = outputdir
        self.outputformat = outputformat
        self.profile = profile
        self.log = log

        self.start()

    def run(self):
        wx.PostEvent(self.notify_window, ResultEvent(PROCESS_START))
        args = Arguments()
        args.outputdir = self.outputdir
        args.log = self.log
        args.outputformat = self.outputformat
        args.profile = self.profile

        log = logging.getLogger('fb2conv-gui')
        log_handler = logging.FileHandler(filename=self.log, mode='a', encoding='utf-8')
        log_handler.setLevel(logging.ERROR)
        log_handler.setFormatter(logging.Formatter('[%(asctime)s] %(levelname)s: %(message)s'))
        if len(log.handlers) == 0:
            log.addHandler(log_handler)


        for f in self.files:
            if self.stop_process:
                wx.PostEvent(self.notify_window, ResultEvent(PROCESS_ABORT))
                return

            wx.PostEvent(self.notify_window, ResultEvent(PROCESS_BEGIN, filename=f))
            wx.CallAfter(pub.sendMessage, 'update')

            args.infile = f
            try:
                result = fb2conv.process(args)
                if result != 0:
                    state = -1
                else:
                    state = 1
            except Exception as e:
                exc_type, exc_obj, exc_tb = sys.exc_info()
                fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
                log.error(u'{filename}:{lineno}:{errtype} {errstr}'.format(filename=fname, lineno=exc_tb.tb_lineno, errtype=exc_type, errstr=str(e)))
                log.error(traceback.format_exc())
                state = -1
            
            wx.PostEvent(self.notify_window, ResultEvent(PROCESS_END, filename=f, state=state))
            wx.CallAfter(pub.sendMessage, 'update')

        wx.PostEvent(self.notify_window, ResultEvent(PROCESS_DONE))
        wx.CallAfter(pub.sendMessage, 'update')

    def abort(self):
        self.stop_process = True


#Drag'n'drop
class ConverterFileDropTarget(wx.FileDropTarget):
    def __init__(self, parent):
        wx.FileDropTarget.__init__(self)
        self.parent = parent

    def OnDropFiles(self, x, y, files):
        self.parent.addFiles(files)


class Arguments():
    def __init__(self):
        self.infile = None
        self.outfile = None
        self.outputformat = None
        self.transliterateauthorandtitle = None
        self.outputdir = None
        self.recursive = False
        self.profile = None
        self.profilelist = None
        self.debug = None
        self.loglevel = None
        self.hyphenate = None
        self.inputdir = None
        self.savestructure = None
        self.deletesourcefile = None
        self.deleteinputdir = None
        self.transliterate = None
        self.kindlecompressionlevel = None
        self.css = None
        self.dropcaps = None
        self.tocmaxlevel = None
        self.notesmode = None
        self.notesbodies = None
        self.annotationtitle = None
        self.toctitle = None
        self.chapteronnewpage = None
        self.tocbeforebody = None
        self.sendtokindle = None
        self.nc = None
        self.cl = None
        self.us = None
        self.nt = None


# Implementing MainFrame
class uiMainFrame( ui.MainFrame ):
    def __init__( self, parent ):
        ui.MainFrame.__init__( self, parent )

        # Drag'n'drop
        drop_target = ConverterFileDropTarget(self)
        self.listFiles.SetDropTarget(drop_target)
        
        self.gaugeProgress.Hide()
        
        self.config_file = None
        self.log = None
        self.config = {}

        config_file_name = 'fb2conv.config'
        log_file_name = 'fb2conv.log'

        application_path = fb2conv.get_executable_path()

        if os.path.exists(os.path.join(application_path, config_file_name)):
            self.config_file = os.path.join(application_path, config_file_name)
            self.log = os.path.join(application_path, log_file_name)
        else:
            if sys.platform == 'win32':
                self.config_file = os.path.join(os.path.expanduser('~'), 'fb2conv', config_file_name)
                self.log = os.path.join(os.path.expanduser('~'), 'fb2conv', log_file_name)
            else:    
                self.config_file = os.path.join(os.path.expanduser('~'), '.fb2conv', config_file_name)
                self.log = os.path.join(os.path.expanduser('~'), '.fb2conv', log_file_name)

        self.config = ConverterConfig(self.config_file)

        self.choiceProfile.Clear()
        self.choiceFormat.Clear()

        self.choiceFormat.Append('epub', 'epub')
        self.choiceFormat.Append('mobi', 'mobi')
        self.choiceFormat.Append('azw3', 'azw3')

        self.listFiles.InsertColumn(0, u'Files')

        for p in self.config.profiles:
            self.choiceProfile.Append(u'{0} ({1})'.format(p, self.config.profiles[p]['description']), p)

        found = False
        if self.config.gui_settings['lastUsedProfile']:
            for idx in range(self.choiceProfile.GetCount()):
                if self.choiceProfile.GetClientData(idx) == self.config.gui_settings['lastUsedProfile']:
                    self.choiceProfile.SetSelection(idx)
                    found = True
                    break
        
        if not found:
            for idx in range(self.choiceProfile.GetCount()):
                if self.choiceProfile.GetClientData(idx).lower() == 'default':
                    self.choiceProfile.SetSelection(idx)
                    break


        found = False
        if self.config.gui_settings['lastUsedFormat']:
            for idx in range(self.choiceFormat.GetCount()):
                if self.choiceFormat.GetClientData(idx) == self.config.gui_settings['lastUsedFormat']:
                    self.choiceFormat.SetSelection(idx)
                    found = True
                    break                
        
        if not found:
            for idx in range(self.choiceFormat.GetCount()):
                if self.choiceFormat.GetClientData(idx).lower() == 'epub':
                    self.choiceFormat.SetSelection(idx)
                    break

        if self.config.gui_settings['outputFolder']:
            self.textOutputDir.SetValue(self.config.gui_settings['outputFolder'])
        else:
            self.textOutputDir.SetValue(os.path.abspath(os.path.expanduser("~/Desktop")))

        self.buttonOpenOutputDir.SetBitmap(images.bulletGo.GetBitmap())
        self.buttonOpenOutputDir.Fit()

        image_list = wx.ImageList(16, 16, True)
        image_list.Add(images.bulletWhite.GetBitmap())
        image_list.Add(images.bulletGo.GetBitmap())
        image_list.Add(images.bulletGreen.GetBitmap())
        image_list.Add(images.bulletRed.GetBitmap())

        self.listFiles.AssignImageList(image_list, wx.IMAGE_LIST_SMALL)

        self.listFiles.Bind(wx.EVT_KEY_DOWN, self.listKeyDown, self.listFiles)
        self.listFiles.Bind(wx.EVT_KEY_UP, self.listKeyUp, self.listFiles)
        self.control_key_pressed = False

        self.worker = None
        self.process_running = False
        self.processed_files = 0

        EVT_RESULT(self, self.onProcessState)
        pub.subscribe(self.updateProgress, "update")

        if self.config.gui_settings['geometry']['x'] and self.config.gui_settings['geometry']['y']:
            self.SetPosition((self.config.gui_settings['geometry']['x'], self.config.gui_settings['geometry']['y']))
            self.SetSize(wx.Size(self.config.gui_settings['geometry']['width'], self.config.gui_settings['geometry']['height']))

        if sys.platform == 'win32':
            self.SetIcon(images.kindle32.getIcon()) 

        self.checkConvertToSourceDir.Value = self.config.gui_settings['convertToSourceDirectory']
        self.enableConvertToSourceDir()

  
    # MainFrame methods
    def openFile(self, filename):
        if sys.platform == 'win32':
            os.startfile(filename)
        elif sys.platform == 'darwin':
            subprocess.Popen(['open', filename])
        else:
            try:
                subprocess.Popen(['xdg-open', filename])
            except:
                pass

    def enableControls(self, state):
        self.menuFileAdd.Enable(state)
        self.menuEditSelectAll.Enable(state)
        self.menuEditDelete.Enable(state)
        self.menuEditViewLog.Enable(state)
        self.menuEditDeleteSuccess.Enable(state)

        self.textOutputDir.Enable(state)
        self.choiceProfile.Enable(state)
        self.choiceFormat.Enable(state)
        self.buttonSelectDir.Enable(state)
        self.checkConvertToSourceDir.Enable(state)
        self.enableConvertToSourceDir()

    def enableConvertToSourceDir(self):
        self.textOutputDir.Enable(not self.checkConvertToSourceDir.Value)
        self.buttonSelectDir.Enable(not self.checkConvertToSourceDir.Value)

    def updateProgress(self):
        self.gaugeProgress.SetValue(self.processed_files)

    def onProcessState(self, event):
        if event.mode == PROCESS_START:
            self.buttonStart.SetLabel(u'Прервать')
            self.menuFileConvert.SetItemLabel(u'Прервать конвертацию')
            self.enableControls(False)
            self.process_running = True
            self.processed_files = 0
            self.gaugeProgress.SetRange(self.listFiles.GetItemCount())
            self.gaugeProgress.SetValue(self.processed_files)
            self.gaugeProgress.Show()

        elif event.mode == PROCESS_DONE:
            self.worker =  None
            self.buttonStart.SetLabel(u'Старт')
            self.menuFileConvert.SetItemLabel(u'Конвертировать')
            self.enableControls(True)
            self.process_running = False
            self.gaugeProgress.Hide()

        elif event.mode == PROCESS_BEGIN:
            self.setConvertState(event.filename, ICON_CURRENT, event.state)

        elif event.mode == PROCESS_END:
            self.processed_files += 1
            if event.state == -1:
                self.setConvertState(event.filename, ICON_ERROR, event.state)
            else:
                self.setConvertState(event.filename, ICON_SUCCESS, event.state)

        elif event.mode == PROCESS_ABORT:
            self.worker = None
            self.buttonStart.SetLabel(u'Старт')
            self.menuFileConvert.SetItemLabel(u'Конвертировать')
            self.enableControls(True)
            self.process_running = False
            self.gaugeProgress.Hide()
            
    def setConvertState(self, filename, icon, state=None):
        for i in range(self.listFiles.GetItemCount()):
            item = self.listFiles.GetItem(i, 0)
            if item.GetText() == filename:
                self.listFiles.SetItemImage(i, icon, icon)
                self.listFiles.EnsureVisible(i)
                if state:
                    self.listFiles.SetItemData(i, state)
                break

    def startConvert(self):
        profile = self.choiceProfile.GetClientData(self.choiceProfile.GetSelection())
        output_format = self.choiceFormat.GetClientData(self.choiceFormat.GetSelection())
        if self.checkConvertToSourceDir.Value:
            output_dir = ''
        else:
            output_dir = self.textOutputDir.GetValue()

        files = []
        for i in range(self.listFiles.GetItemCount()):
            files.append(self.listFiles.GetItem(i, 0).GetText())

        self.worker = Worker(self, files, profile=profile, outputdir=output_dir, outputformat=output_format, log=self.log)

    def stopConvert(self):
        if self.worker:
            self.worker.abort()

    def selectAllItems(self):
        for i in range(self.listFiles.GetItemCount()):
            self.listFiles.SetItemState(i, wx.LIST_STATE_SELECTED, wx.LIST_STATE_SELECTED)
            self.listFiles.SetFocus()

    def deleteSuccess(self):
        while True:
            found = False
            
            for i in range(self.listFiles.GetItemCount()):
                if self.listFiles.GetItemData(i) == 1:
                    self.listFiles.DeleteItem(i)
                    found = True
                    break

            if not found:
                break


    def deleteSelected(self):
        prev_index = -1
        index = -1
        while True:
            index = self.listFiles.GetFirstSelected(index)
            if index == -1:
                break
            else:
                self.listFiles.DeleteItem(index)
                prev_index = index

        self.listFiles.SetFocus()
        if prev_index < self.listFiles.ItemCount:
            self.listFiles.Select(prev_index)
        else:
            self.listFiles.Select(self.listFiles.ItemCount - 1)

    def exitApp(self):
        profile = self.choiceProfile.GetClientData(self.choiceProfile.GetSelection())
        output_format = self.choiceFormat.GetClientData(self.choiceFormat.GetSelection())
        output_folder = self.textOutputDir.GetValue()
        convert_to_source_dir = self.checkConvertToSourceDir.Value

        if profile:
            self.config.gui_settings['lastUsedProfile'] = profile
        if output_format:
            self.config.gui_settings['lastUsedFormat'] = output_format
        if output_folder:
            self.config.gui_settings['outputFolder'] = output_folder
        if convert_to_source_dir:
            self.config.gui_settings['convertToSourceDirectory'] = str(convert_to_source_dir)

        win_x, win_y = self.GetPosition()
        win_width, win_height = self.GetSize()

        self.config.gui_settings['geometry']['x'] = win_x
        self.config.gui_settings['geometry']['y'] = win_y
        self.config.gui_settings['geometry']['width'] = win_width
        self.config.gui_settings['geometry']['height'] = win_height

        self.config.write()
        self.Destroy()

    def addFile(self, file):
        if not file.lower().endswith((".fb2", ".fb2.zip", ".zip")):
            return
        
        found = False    
        for i in range(self.listFiles.GetItemCount()):
            if file == self.listFiles.GetItem(i, 0).GetText():
                found = True
                break
    
        if not found:
            index = self.listFiles.GetItemCount()
            self.listFiles.InsertImageStringItem(index, file, 0)
 
    def addFiles(self, file_list):
        for item in file_list:
            if os.path.isdir(item):
                for root, dirs, files in os.walk(item):
                    for f in files:
                        self.addFile(os.path.join(root, f))
            else:
                self.addFile(item)

    # Handlers for MainFrame events.
    def listKeyUp(self, event):
        keycode = event.GetKeyCode()

        if keycode == wx.WXK_CONTROL:
            self.control_key_pressed = False
        else:
            event.Skip()


    def listKeyDown(self, event):
        keycode = event.GetKeyCode()

        if keycode == wx.WXK_DELETE:
            self.deleteSelected()
        elif keycode == wx.WXK_CONTROL:
            self.control_key_pressed = True
        elif keycode == wx.WXK_BACK:
            if self.control_key_pressed:
                self.deleteSelected()
        else:
            event.Skip()


    def MainWindowOnClose( self, event ):
        self.exitApp()

    def textOutputDirOnKillFocus( self, event ):
        self.output_dir = self.textOutputDir.GetValue()
        if self.output_dir:
            if not os.path.exists(self.output_dir):
                wx.MessageDialog(self, u'Папка "{0} не найдена."'.format(self.output_dir), u"Ошибка", wx.OK | wx.ICON_ERROR).ShowModal()
                self.output_dir = None
                self.textOutputDir.SetValue('')
                wx.CallAfter(self.textOutputDir.SetFocus)
                self.refocus = True 
        
        event.Skip()

    def buttonSelectDirOnCLick( self, event ):
        if self.textOutputDir.GetValue():
            default_path = self.textOutputDir.GetValue()
        else:
            default_path = os.path.abspath(os.path.expanduser('~/Documents'))
            if not os.path.exists(default_path):
                default_path = None

        dirDlg = wx.DirDialog(self, u'Каталог для помещения файлов', defaultPath=default_path, style=wx.DD_DEFAULT_STYLE|wx.DD_NEW_DIR_BUTTON)
        if dirDlg.ShowModal() == wx.ID_OK:
            self.textOutputDir.SetValue(dirDlg.GetPath())

    def buttonStartOnClick( self, event ):
        if not self.process_running:
            self.startConvert()
        else:
            self.stopConvert()

    def onCheckConvertToSourceDir(self, event):
        self.enableConvertToSourceDir()
    
    def buttonOpenOutputDirOnClick(self, event):
        if self.textOutputDir.GetValue():
            self.openFile(self.textOutputDir.GetValue())

    def menuFileAddOnSelect( self, event ):
        fileDlg = wx.FileDialog(self, u"Выберите файлы", wildcard = u'Файлы fb2 (*.fb2,*.fb2.zip,*.zip)|*.fb2;*.fb2.zip;*.zip|Все файлы (*.*)|*.*', style = wx.OPEN | wx.MULTIPLE | wx.CHANGE_DIR)
        if fileDlg.ShowModal() == wx.ID_OK:
            self.addFiles(fileDlg.GetPaths())
    
    def menuFileConvertOnSelect( self, event ):
        if not self.process_running:
            self.startConvert()
        else:
            self.stopConvert()
    
    def menuFileExitOnSelect( self, event ):
        self.exitApp()
    
    def menuEditSelectAllOnSelect( self, event ):
        self.selectAllItems()
    
    def menuEditDeleteOnSelect( self, event ):
        self.deleteSelected()
    
    def menuEditDeleteSuccessOnSelect(self, event):
        self.deleteSuccess()

    def menuEditViewLogOnSelect( self, event ):
        self.openFile(self.log)
    
    def menuHelpSupportOnSelect( self, event ):
        webbrowser.open(url=SUPPORT_URL)
    
    def menuHelpAboutOnSelect( self, event ):
        about_dialog = uiDialogAbout(self)
        about_dialog.ShowModal()

    
    
