'''
This is a setup.py script generated by py2applet

Usage:
    python setup.py py2app
'''

from setuptools import setup
import sys
import os

base_dir = os.path.abspath(os.path.dirname(sys.argv[0]))
sys.path.append(os.path.join(base_dir, 'modules'))
sys.path.append(os.path.join(base_dir, 'modules/kindleunpack'))

sys.argv.append('py2app')

try:
    shutil.rmtree(os.path.join(base_dir, 'build'))
except:
    pass
try:
    shutil.rmtree(os.path.join(base_dir, 'dist'))
except:
    pass

includes = [
    'lxml.etree', 
    'lxml._elementpath', 
    'gzip', 
    'hyphenations.ru', 
    'hyphenations.en',
    'hyphenations.uk',
    'hyphenations.de',
    'kindleunpack',
    'default_css',
    'email',
    'email.mime.base',
    'email.mime.multipart',
    'email.mime.text',
    'wx.lib.pubsub.*',
    'wx.lib.pubsub.core.*',
    'wx.lib.pubsub.core.kwargs.*'
]

APP = ['fb2conv-gui.py']
DATA_FILES = []
OPTIONS = {
	'argv_emulation': True, 
	'includes': includes,
	'iconfile': 'images/fb2conv.icns'
}

setup(
    app=APP,
    data_files=DATA_FILES,
    options={'py2app': OPTIONS},
    setup_requires=['py2app'],
)
