#!/usr/bin/env python
# -*- coding: utf-8 -*-
__author__ = 'alone'
'''
  Примеры использования:
	python kindleunpackwrapper.py "F:\temp\Downloads\Тест 1\Бигл П С - Последний единорог.mobi"  
		обработка файла
	python kindleunpackwrapper.py -d "F:\temp\Downloads\Тест 1"  
		обработка папки F:\temp\Downloads\Тест 1, удалить исходные .mobi
	python kindleunpackwrapper.py -d -r "F:\temp\Downloads\Тест 1"  
		обработка папки F:\temp\Downloads\Тест 1, включая подпапки, удалить исходные .mobi
'''

import os
import argparse
import sys
import tempfile
import shutil
import locale
import codecs

sys.path.append(os.path.join(os.path.dirname(__file__), 'kindleunpack'))

import kindleunpack

VERSION = '1.0'

class RedirectStdStreams(object):
    def __init__(self, stdout=None, stderr=None):
        self._stdout = stdout or sys.stdout
        self._stderr = stderr or sys.stderr

    def __enter__(self):
        self.old_stdout, self.old_stderr = sys.stdout, sys.stderr
        self.old_stdout.flush(); self.old_stderr.flush()
        sys.stdout, sys.stderr = self._stdout, self._stderr

    def __exit__(self, exc_type, exc_value, traceback):
        self._stdout.flush(); self._stderr.flush()
        sys.stdout = self.old_stdout
        sys.stderr = self.old_stderr

def process_file(file, tmpdir):
	devnull = open(os.devnull, 'w')
	with RedirectStdStreams(stdout=devnull, stderr=devnull):
		kindleunpack.unpackBook(file.decode(locale.getpreferredencoding()).encode('utf-8'), tmpdir, False, False, True)

